<?php
// PHP code to display products from the database

$servername = "localhost";
$username = "wintelsoft_vinod";
$password = "vinodbhaskar69*";
$dbname = "wintelsoft_svf";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Handle filtering and sorting
$filter_status = isset($_GET['status']) ? $_GET['status'] : 'all';
$sql_filter = "SELECT product_code, date_of_order, customer_name, item_description, measurements_and_specification, quantity, scheduled_date_of_delivery, product_image, despatched_status FROM products";

if ($filter_status == 'Yes') {
    $sql_filter .= " WHERE despatched_status = 'Yes'";
} elseif ($filter_status == 'No') {
    $sql_filter .= " WHERE despatched_status = 'No'";
}

$sql_filter .= " ORDER BY product_code ASC"; // Sorting in ascending order by product_code

$result = $conn->query($sql_filter);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Products</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap');
        
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f0f2f5;
            color: #333;
            line-height: 1.6;
            margin: 0;
            padding: 20px;
        }

        .container {
            max-width: 1200px;
            margin: 40px auto;
            background-color: #ffffff;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            overflow-x: auto;
        }

        h2 {
            text-align: center;
            color: #ffffff;
            background-color: #3498db;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 30px;
            font-weight: 700;
            letter-spacing: 1px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            min-width: 800px;
        }

        th, td {
            padding: 12px 15px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }

        th {
            background-color: #34495e;
            color: white;
            font-weight: bold;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        tr:hover {
            background-color: #e9e9e9;
        }

        .add-link-container {
            text-align: center;
            margin-bottom: 20px;
        }

        .add-link-container a {
            background-color: #2ecc71;
            color: white;
            padding: 12px 25px;
            border-radius: 8px;
            text-decoration: none;
            font-weight: bold;
            transition: background-color 0.3s, transform 0.2s;
        }

        .add-link-container a:hover {
            background-color: #27ae60;
            transform: translateY(-2px);
        }

        .product-image {
            max-width: 100px;
            height: auto;
            border-radius: 4px;
        }

        .filter-container {
            margin-bottom: 20px;
            text-align: right;
        }

        .filter-container label, .filter-container select {
            font-size: 16px;
            margin-right: 10px;
        }
        
        a {
            color: #3498db;
            text-decoration: none;
            font-weight: bold;
        }

        a:hover {
            text-decoration: underline;
        }

        @media (max-width: 768px) {
            .container {
                padding: 20px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>View Products</h2>

        <div class="filter-container">
            <form method="get" action="add_daily_process.php">
                <label for="status">Filter by Despatch Status:</label>
                <select name="status" id="status" onchange="this.form.submit()">
                    <option value="all" <?php echo ($filter_status == 'all') ? 'selected' : ''; ?>>All</option>
                    <option value="Yes" <?php echo ($filter_status == 'Yes') ? 'selected' : ''; ?>>Yes</option>
                    <option value="No" <?php echo ($filter_status == 'No') ? 'selected' : ''; ?>>No</option>
                </select>
            </form>
        </div>


        <table>
            <thead>
                <tr>
                    <th>Product Code</th>
                    <th>Date of Order</th>
                    <th>Customer Name</th>
                    <th>Item Description</th>
                    <th>Measurements & Specification</th>
                    <th>Quantity</th>
                    <th>Scheduled Date of Delivery</th>
                    <th>Product Image</th>
                    <th>Despatched Status</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($result->num_rows > 0) {
                    while($row = $result->fetch_assoc()) {
                        echo "<tr>";
                        echo "<td><a href='daily_process.php?product_code=" . urlencode($row["product_code"]) . "'>" . htmlspecialchars($row["product_code"]) . "</a></td>";
                        echo "<td>" . date('d/m/Y', strtotime($row["date_of_order"])) . "</td>";
                        echo "<td>" . htmlspecialchars($row["customer_name"]) . "</td>";
                        echo "<td>" . htmlspecialchars($row["item_description"]) . "</td>";
                        echo "<td>" . htmlspecialchars($row["measurements_and_specification"]) . "</td>";
                        echo "<td>" . htmlspecialchars($row["quantity"]) . "</td>";
                        echo "<td>" . htmlspecialchars($row["scheduled_date_of_delivery"]) . "</td>";
                        
                        echo "<td>";
                        if (!empty($row["product_image"])) {
                            echo "<img src='uploads/" . htmlspecialchars($row["product_image"]) . "' alt='Product Image' class='product-image'>";
                        } else {
                            echo "No Image";
                        }
                        echo "</td>";
                        
                        echo "<td>" . htmlspecialchars($row["despatched_status"]) . "</td>";
                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td colspan='9'>No products found.</td></tr>";
                }
                $conn->close();
                ?>
            </tbody>
        </table>
    </div>
</body>
</html>
