<?php
// --- PHP Backend Logic ---
// This script handles updating an existing process record.

// Configuration variables for your database connection.
$servername = "localhost";
$username = "wintelsoft_vinod";
$password = "vinodbhaskar69*";
$dbname = "wintelsoft_svf";

$process_code = $process_name = $process_group = $rate = $unit_of_measurement = "";
$message = "";
$is_success = false;

// Check if an edit request came through the URL
if (isset($_GET['edit'])) {
    $process_code_to_edit = filter_input(INPUT_GET, 'edit', FILTER_SANITIZE_STRING);

    $conn = new mysqli($servername, $username, $password, $dbname);
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    $sql = "SELECT process_code, process_name, process_group, rate, unit_of_measurement FROM processes WHERE process_code = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $process_code_to_edit);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $process_code = $row['process_code'];
        $process_name = $row['process_name'];
        $process_group = $row['process_group'];
        $rate = $row['rate'];
        $unit_of_measurement = $row['unit_of_measurement'];
    } else {
        $message = "Error: Process not found.";
        $is_success = false;
    }
    
    $stmt->close();
    $conn->close();

} else if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Handle form submission for updating the record
    $original_process_code = filter_input(INPUT_POST, 'original_process_code', FILTER_SANITIZE_STRING);
    $process_code = filter_input(INPUT_POST, 'process_code', FILTER_SANITIZE_STRING);
    $process_name = filter_input(INPUT_POST, 'process_name', FILTER_SANITIZE_STRING);
    $process_group = filter_input(INPUT_POST, 'process_group', FILTER_SANITIZE_STRING);
    $rate = filter_input(INPUT_POST, 'rate', FILTER_VALIDATE_FLOAT);
    $unit_of_measurement = filter_input(INPUT_POST, 'unit_of_measurement', FILTER_SANITIZE_STRING);

    if (!$process_code || !$process_name || !$process_group || $rate === false || !$unit_of_measurement || !$original_process_code) {
        $message = "Please fill out all the fields correctly.";
        $is_success = false;
    } else {
        $conn = new mysqli($servername, $username, $password, $dbname);
        if ($conn->connect_error) {
            die("Connection failed: " . $conn->connect_error);
        }

        // Use a prepared statement to update the record.
        $sql = "UPDATE processes SET process_code = ?, process_name = ?, process_group = ?, rate = ?, unit_of_measurement = ? WHERE process_code = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sssdss", $process_code, $process_name, $process_group, $rate, $unit_of_measurement, $original_process_code);
        
        if ($stmt->execute()) {
            $message = "Record updated successfully!";
            $is_success = true;
        } else {
            $message = "Error updating record: " . $stmt->error;
            $is_success = false;
        }
        
        $stmt->close();
        $conn->close();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Process</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap');
        
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f0f2f5;
            color: #333;
            line-height: 1.6;
            margin: 0;
            padding: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
        }

        .container {
            max-width: 800px;
            margin: 40px auto;
            background-color: #ffffff;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            width: 100%;
        }

        h2 {
            text-align: center;
            color: #ffffff;
            background-color: #3498db;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 30px;
            font-weight: 700;
            letter-spacing: 1px;
        }

        .alert-message {
            text-align: center;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 8px;
            font-weight: bold;
        }

        .alert-error {
            background-color: #e74c3c;
            color: white;
        }

        .alert-success {
            background-color: #2ecc71;
            color: white;
        }

        .form-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        .form-table td {
            padding: 15px;
            vertical-align: top;
        }

        .form-table td:first-child {
            width: 30%;
            text-align: right;
            font-weight: bold;
            padding-right: 20px;
            color: #555;
        }

        .form-table input[type="text"],
        .form-table input[type="number"],
        .form-table select {
            width: 50%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 8px;
            box-sizing: border-box;
            font-size: 16px;
            transition: border-color 0.3s, box-shadow 0.3s;
        }

        .form-table input:focus,
        .form-table select:focus {
            border-color: #3498db;
            box-shadow: 0 0 8px rgba(52, 152, 219, 0.2);
            outline: none;
        }
        
        .submit-container {
            text-align: center;
            padding-top: 20px;
        }

        input[type="submit"] {
            background-color: #2ecc71;
            color: white;
            padding: 15px 30px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 18px;
            font-weight: bold;
            transition: background-color 0.3s, transform 0.2s;
        }

        input[type="submit"]:hover {
            background-color: #27ae60;
            transform: translateY(-2px);
        }

        .view-link {
            display: block;
            text-align: center;
            margin-top: 20px;
        }

        .view-link a {
            color: #3498db;
            text-decoration: none;
            font-weight: bold;
        }

        .view-link a:hover {
            text-decoration: underline;
        }

        /* Responsive design */
        @media (max-width: 600px) {
            .form-table td {
                display: block;
                width: 100%;
                text-align: left !important;
                padding: 10px 0;
            }
            .form-table td:first-child {
                padding-right: 0;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Edit Process</h2>
        
        <?php if ($message): ?>
            <div class="alert-message <?php echo $is_success ? 'alert-success' : 'alert-error'; ?>">
                <p><?php echo htmlspecialchars($message); ?></p>
            </div>
        <?php endif; ?>

        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>" method="post">
            <input type="hidden" name="original_process_code" value="<?php echo htmlspecialchars($process_code); ?>">
            <table class="form-table">
                <tbody>
                    <!-- Process Code Field (Read-only to prevent changes to the key) -->
                    <tr>
                        <td><label for="process_code">Process Code</label></td>
                        <td>
                            <input type="text" id="process_code" name="process_code" value="<?php echo htmlspecialchars($process_code); ?>" required readonly>
                        </td>
                    </tr>
                    
                    <!-- Process Name Field -->
                    <tr>
                        <td><label for="process_name">Process Name</label></td>
                        <td>
                            <input type="text" id="process_name" name="process_name" value="<?php echo htmlspecialchars($process_name); ?>" required>
                        </td>
                    </tr>
                    
                    <!-- Process Group Field -->
                    <tr>
                        <td><label for="process_group">Process Group</label></td>
                        <td>
                            <input type="text" id="process_group" name="process_group" value="<?php echo htmlspecialchars($process_group); ?>" required>
                        </td>
                    </tr>

                    <!-- Rate Field -->
                    <tr>
                        <td><label for="rate">Rate</label></td>
                        <td>
                            <input type="number" id="rate" name="rate" step="0.01" value="<?php echo htmlspecialchars($rate); ?>" required>
                        </td>
                    </tr>

                    <!-- Unit of Measurement Field -->
                    <tr>
                        <td><label for="unit_of_measurement">Unit of Measurement</label></td>
                        <td>
                            <select id="unit_of_measurement" name="unit_of_measurement" required>
                                <?php
                                $units = ["Cu.Ft","Rupees","Hrs", "Day", "Kg", "Nos", "Litters", "Unit", "Pcs"];
                                foreach ($units as $unit) {
                                    $selected = ($unit_of_measurement == $unit) ? 'selected' : '';
                                    echo "<option value=\"$unit\" $selected>$unit</option>";
                                }
                                ?>
                            </select>
                        </td>
                    </tr>

                    <!-- Submit Button -->
                    <tr>
                        <td colspan="2" class="submit-container">
                            <input type="submit" value="Update Process">
                        </td>
                    </tr>
                </tbody>
            </table>
        </form>

        <div class="view-link">
            <a href="view_process.php">View All Processes</a>
        </div>
    </div>
</body>
</html>
