<?php
// Start the session to enable session variable usage
session_start();

// Check if the user ID is set in the session. If not, the user is not logged in.
if (!isset($_SESSION['user_id'])) {
    // Redirect to the login page
    header("Location: login.php");
    exit();
}
$user_id = $_SESSION['user_id'];

// Database connection details
$servername = "localhost";
$username = "wintelsoft_vinod";
$password = "vinodbhaskar69*";
$dbname = "wintelsoft_svf";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Prepare and execute a query to get the user's rights
$user_rights = '';
$stmt = $conn->prepare("SELECT user_rights FROM users WHERE user_id = ?");

// Note: Assuming user_id is passed as a string/username, binding as 's' (string)
if ($stmt) {
    // Assuming user_id in the session is the user's login identifier
    $stmt->bind_param("s", $user_id); 
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $user_rights = $row['user_rights']; // This will be 'Super_user', 'Admin', or 'User'
    }
    $stmt->close();
}
$conn->close();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Product Management</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap');

        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f0f2f5;
            color: #333;
            line-height: 1.6;
            margin: 0;
            padding: 20px;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }

        .container {
            max-width: 600px;
            margin: auto;
            background-color: #ffffff;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            text-align: center;
        }

        h2 {
            color: #ffffff;
            background-color: #3498db;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 30px;
            font-weight: 700;
            letter-spacing: 1px;
        }

        p.role-info {
            color: #2c3e50;
            font-weight: 500;
            margin-bottom: 20px;
            padding: 10px;
            border: 1px dashed #3498db;
            border-radius: 5px;
        }

        .link-container {
            display: flex;
            flex-direction: column;
            gap: 15px; /* Reduced gap slightly for more links */
            margin-top: 30px;
        }

        .link-container a {
            background-color: #2ecc71;
            color: white;
            padding: 15px 30px;
            border-radius: 8px;
            text-decoration: none;
            font-size: 18px;
            font-weight: bold;
            transition: background-color 0.3s, transform 0.2s;
        }
        
        /* Specific styling for the User Management link */
        .link-container a.super-link {
            background-color: #e67e22; /* Orange color */
        }
        
        /* Specific styling for the Logout link */
        .link-container a.logout-link {
            background-color: #e74c3c; /* Red color */
        }

        .link-container a:hover {
            background-color: #27ae60;
            transform: translateY(-2px);
        }
        
        .link-container a.super-link:hover {
            background-color: #d35400;
        }
        
        .link-container a.logout-link:hover {
            background-color: #c0392b;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Welcome to the Product Management System</h2>
        <p class="role-info">You are logged in as: <strong><?php echo htmlspecialchars($user_rights); ?></strong></p>
        <p>Please select an option to proceed:</p>
        <div class="link-container">
            
            <?php 
            // 1. User Management: Accessible only to Super_user
            if ($user_rights === 'Super_user'): ?>
                <a href="user_management.php" target="_blank" class="super-link">User Management</a>
            <?php endif; ?>
            
            <?php 
            // 2. Add New Process in Master (Original 6th, now 2nd): Accessible only to Super_user
            if ($user_rights === 'Super_user'): ?>
                <a href="add_process.php" target="_blank">Add New Process in Master</a>
            <?php endif; ?>
            
            <?php 
            // 3. View All Processes in Master (Original 7th, now 3rd): Accessible only to Super_user
            if ($user_rights === 'Super_user'): ?>
                <a href="view_process.php" target="_blank">View All Processes in Master</a>
            <?php endif; ?>
            
            <?php 
            // 4. Add new product (Original 2nd, now 4th): Accessible to Super_user, Admin, User
            if (in_array($user_rights, ['Super_user', 'Admin', 'User'])): ?>
                <a href="add.php" target="_blank">Add New Product</a>
            <?php endif; ?>
            
            <?php 
            // 5.1 View all products (Original 3rd, now 5th): Accessible to Super_user, Admin, User
            if (in_array($user_rights, ['Super_user', 'Admin', 'User'])): ?>
                <a href="add_from_existing.php" target="_blank">Add from Existing Products</a>
            <?php endif; ?>            
            

            <?php 
            // 5. View all products (Original 3rd, now 5th): Accessible to Super_user, Admin, User
            if (in_array($user_rights, ['Super_user', 'Admin', 'User'])): ?>
                <a href="view_products.php" target="_blank">View All Products</a>
            <?php endif; ?>

            <?php 
            // 6. Add Daily Process (Original 4th, now 6th): Accessible to Super_user, Admin
            if (in_array($user_rights, ['Super_user', 'Admin'])): ?>
                <a href="add_daily_process.php" target="_blank">Add Daily Process</a>
            <?php endif; ?>
            
            <?php 
            // 7. View Cost Report (Original 5th, now 7th): Accessible only to Super_user
            if ($user_rights === 'Super_user'): ?>
                <a href="view_cost_select.php" target="_blank">View Cost Report</a>
            <?php endif; ?>
            
            <!-- Standard Logout Link -->
            <a href="logout.php" class="logout-link">Logout</a>

        </div>
    </div>
</body>
</html>
