<?php
// Start the session to enable session variable usage
session_start();

// Check if the user ID is set in the session. If not, the user is not logged in.
if (!isset($_SESSION['user_id'])) {
    // Redirect to the login page
    header("Location: login.php");
    exit();
}
$user_id = $_SESSION['user_id'];

// Database connection details
$servername = "localhost";
$username = "wintelsoft_vinod";
$password = "vinodbhaskar69*";
$dbname = "wintelsoft_svf";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Prepare and execute a query to get the user's rights
$user_rights = '';
$stmt = $conn->prepare("SELECT user_rights FROM users WHERE user_id = ?");
if ($stmt) {
    $stmt->bind_param("s", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $user_rights = $row['user_rights'];
    }
    $stmt->close();
}
$conn->close();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Product Management</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap');

        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f0f2f5;
            color: #333;
            line-height: 1.6;
            margin: 0;
            padding: 20px;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }

        .container {
            max-width: 600px;
            margin: auto;
            background-color: #ffffff;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            text-align: center;
        }

        h2 {
            color: #ffffff;
            background-color: #3498db;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 30px;
            font-weight: 700;
            letter-spacing: 1px;
        }

        .link-container {
            display: flex;
            flex-direction: column;
            gap: 20px;
            margin-top: 30px;
        }

        .link-container a {
            background-color: #2ecc71;
            color: white;
            padding: 15px 30px;
            border-radius: 8px;
            text-decoration: none;
            font-size: 18px;
            font-weight: bold;
            transition: background-color 0.3s, transform 0.2s;
        }

        .link-container a:hover {
            background-color: #27ae60;
            transform: translateY(-2px);
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Welcome to the Product Management System</h2>
        <p>Please select an option to proceed:</p>
        <div class="link-container">
            <?php if ($user_rights === 'Admin'): ?>
                <!-- Display all links for admin users -->
                <a href="add.php" target="_blank">Add New Product</a>
                <a href="view_products.php" target="_blank">View All Products</a>
                <a href="add_process.php" target="_blank">Add New Process in Master </a>
                <a href="view_process.php" target="_blank">View All Processes in Master</a>
                <a href="add_daily_process.php" target="_blank">Add Daily Process</a>
                <a href="view_cost_select.php" target="_blank">View Cost Report</a>
            <?php else: ?>
                <!-- Display limited links for regular users -->
                <a href="add_daily_process.php" target="_blank">Add Daily Process</a>
                <a href="view_cost_select.php" target="_blank">View Cost Report</a>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>
