<?php
// Start a session to store user information
session_start();

// Initialize message variables
$message = "";
$status = "";

// Database credentials
$servername = "localhost";
$username = "wintelsoft_vinod";
$password = "vinodbhaskar69*";
$dbname = "wintelsoft_svf";

// Create a new database connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check if the connection was successful
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Check if the form was submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Sanitize user input
    $user_id = trim($_POST['user_id']);
    $user_password = trim($_POST['password']);
    
    // Simple validation: check if fields are empty
    if (empty($user_id) || empty($user_password)) {
        $status = "error";
        $message = "User ID and Password are required.";
    } else {
        // Use a prepared statement to prevent SQL injection.
        $stmt = $conn->prepare("SELECT password FROM users WHERE user_id = ?");
        $stmt->bind_param("s", $user_id);
        $stmt->execute();
        $result = $stmt->get_result();

        // Check if a user was found
        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $stored_password = $row['password'];

            // DIRECT PASSWORD COMPARISON
            // WARNING: This is highly insecure. Passwords should never be stored or compared in plain text.
            if ($user_password == $stored_password) {
                // Password is correct.
                $_SESSION['user_id'] = $user_id;

                // Redirect to the success page
                header("Location: index.php");
                exit();
            } else {
                // Invalid password
                $status = "error";
                $message = "Invalid User ID or Password.";
            }
        } else {
            // No user found
            $status = "error";
            $message = "Invalid User ID or Password.";
        }
        
        $stmt->close();
    }
}

// Close the database connection
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Login</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f0f2f5;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .login-container {
            background-color: #ffffff;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 400px;
            text-align: center;
        }
        h2 {
            margin-bottom: 24px;
            color: #333;
        }
        .form-group {
            margin-bottom: 20px;
            text-align: left;
        }
        label {
            display: block;
            margin-bottom: 8px;
            color: #555;
            font-weight: bold;
        }
        input[type="text"],
        input[type="password"] {
            width: 100%;
            padding: 12px;
            border: 1px solid #ccc;
            border-radius: 8px;
            box-sizing: border-box;
            font-size: 16px;
        }
        button {
            width: 100%;
            padding: 12px;
            background-color: #007bff;
            color: #fff;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }
        button:hover {
            background-color: #0056b3;
        }
        .message {
            margin-top: 20px;
            padding: 10px;
            border-radius: 8px;
            font-size: 14px;
        }
        .error {
            background-color: #ffe5e5;
            color: #e53935;
            border: 1px solid #e53935;
        }
        .success {
            background-color: #e5ffe5;
            color: #388e3c;
            border: 1px solid #388e3c;
        }
    </style>
</head>
<body>

<div class="login-container">
    <h2>User Login</h2>
    
    <?php
    // Display the message if one exists
    if (!empty($message)) {
        echo "<div class='message $status'>$message</div>";
    }
    ?>

    <form action="" method="post">
        <div class="form-group">
            <label for="user_id">User ID:</label>
            <input type="text" id="user_id" name="user_id" required>
        </div>
        <div class="form-group">
            <label for="password">Password:</label>
            <input type="password" id="password" name="password" required>
        </div>
        <button type="submit">Login</button>
    </form>
</div>

</body>
</html>
