<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Management</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap');

        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f0f2f5;
            color: #333;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
            padding: 20px;
        }

        .dashboard-container {
            background-color: #ffffff;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            text-align: center;
            width: 100%;
            max-width: 600px;
        }

        h2 {
            color: #3498db;
            margin-bottom: 30px;
            font-weight: 700;
        }

        .icon-links {
            display: flex;
            justify-content: center;
            gap: 20px;
            flex-wrap: wrap;
        }

        .link-card {
            text-decoration: none;
            color: #555;
            background-color: #f8f9fa;
            border: 1px solid #e0e0e0;
            padding: 20px;
            border-radius: 10px;
            width: 150px;
            display: flex;
            flex-direction: column;
            align-items: center;
            transition: transform 0.3s, box-shadow 0.3s, background-color 0.3s;
        }

        .link-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 15px rgba(0, 0, 0, 0.1);
            background-color: #e9ecef;
        }

        .link-icon {
            font-size: 3em;
            color: #3498db;
            margin-bottom: 10px;
        }

        .link-text {
            font-weight: 600;
            font-size: 1.1em;
        }
    </style>
</head>
<body>

<div class="dashboard-container">
    <h2>User Management Dashboard</h2>
    <div class="icon-links">
        <a href="user_add.php" class="link-card" target="_blank">
            <i class="fas fa-user-plus link-icon"></i>
            <span class="link-text">Add New User</span>
        </a>
        <a href="manage_users.php" class="link-card" target="_blank">
            <i class="fas fa-users link-icon"></i>
            <span class="link-text">Manage Users</span>
        </a>
    </div>
</div>

</body>
</html>
