<?php
// PHP code to display product details and daily process history

$servername = "localhost";
$username = "wintelsoft_vinod";
$password = "vinodbhaskar69*";
$dbname = "wintelsoft_svf";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
  die("Connection failed: " . $conn->connect_error);
}

$product_code = isset($_GET['product_code']) ? $_GET['product_code'] : '';
$product_details = null;
$daily_process_data = [];
$total_amount = 0;

if (!empty($product_code)) {
  $safe_product_code = $conn->real_escape_string($product_code);
 
  // Get product details
  $sql_product = "SELECT * FROM products WHERE product_code = '$safe_product_code'";
  $result_product = $conn->query($sql_product);
  if ($result_product->num_rows > 0) {
    $product_details = $result_product->fetch_assoc();
  }
}

// Fetch daily process data for the selected product, including user_id
if (!empty($product_code)) {
  $sql_daily_data = "SELECT dp.id, dp.date, p.process_name, dp.description, dp.quantity, dp.rate, dp.amount, dp.user_id FROM daily_process dp JOIN processes p ON dp.process_code = p.process_code WHERE dp.product_code = '$safe_product_code' ORDER BY dp.date ASC";
  $result_daily_data = $conn->query($sql_daily_data);
  if ($result_daily_data->num_rows > 0) {
    while($row = $result_daily_data->fetch_assoc()) {
      $daily_process_data[] = $row;
      $total_amount += $row['amount'];
    }
  }
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Daily Process</title>
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap');
   
    body {
      font-family: 'Roboto', sans-serif;
      background-color: #f0f2f5;
      color: #333;
      line-height: 1.6;
      margin: 0;
      padding: 20px;
    }

    .container {
      max-width: 900px;
      margin: 40px auto;
      background-color: #ffffff;
      padding: 40px;
      border-radius: 12px;
      box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
    }
   
    .header {
      display: flex;
      align-items: center;
      justify-content: space-between;
      margin-bottom: 20px;
    }

    .product-info {
      display: flex;
      align-items: center;
      gap: 20px;
    }
   
    .product-info h2 {
      margin: 0;
      font-size: 24px;
      color: #3498db;
    }

    .product-image {
      max-width: 80px;
      border-radius: 8px;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    }

    h3 {
      border-bottom: 2px solid #3498db;
      padding-bottom: 10px;
      margin-top: 30px;
      margin-bottom: 20px;
    }

    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 20px;
      overflow-x: auto;
      display: block;
    }

    th, td {
      padding: 12px 15px;
      text-align: left;
      border-bottom: 1px solid #ddd;
    }

    th {
      background-color: #34495e;
      color: white;
      font-weight: bold;
    }

    tr:nth-child(even) {
      background-color: #f2f2f2;
    }

    tr:hover {
      background-color: #e9e9e9;
    }
   
    .total-row {
      font-weight: bold;
      /* CHANGED: New background color to dark gray */
      background-color: #54595F; 
    }
        /* Explicitly set the color for the cells within the total row to white for contrast */
        .total-row td {
            color: white !important; 
            border-bottom: none; 
        }
        /* Add right alignment for quantity, rate, and amount data cells for better number readability */
        td:nth-child(4), td:nth-child(5), td:nth-child(6), td:nth-child(7) {
            text-align: right;
        }
  </style>
</head>
<body>
  <div class="container">
    <?php if ($product_details): ?>
      <div class="header">
        <div class="product-info">
          <?php if (!empty($product_details['product_image'])): ?>
            <img src="uploads/<?php echo htmlspecialchars($product_details['product_image']); ?>" alt="Product Image" class="product-image">
          <?php endif; ?>
          <div>
            <h2>Daily Process History for <?php echo htmlspecialchars($product_details['product_code']); ?></h2>
            <p><?php echo htmlspecialchars($product_details['item_description']); ?></p>
            <p>Customer: <?php echo htmlspecialchars($product_details['customer_name']); ?></p>
          </div>
        </div>
      </div>
     
      <h3 style="text-align:center;">Daily Process History</h3>
      <table>
        <thead>
          <tr>
            <th>Date</th>
            <th>Process Name</th>
            <th>Description</th>
            <th>Quantity</th>
            <th>Rate</th>
            <th>Amount</th>
            <th>User ID</th>
          </tr>
        </thead>
        <tbody>
          <?php if (count($daily_process_data) > 0): ?>
            <?php foreach ($daily_process_data as $data): ?>
              <tr>
                <td>
                  <?php echo date('d-m-Y', strtotime($data['date'])); ?>
                </td>
                <td><?php echo htmlspecialchars($data['process_name']); ?></td>
                <td><?php echo htmlspecialchars($data['description']); ?></td>
                <td><?php echo htmlspecialchars($data['quantity']); ?></td>
                <td><?php echo htmlspecialchars($data['rate']); ?></td>
                <td><?php echo htmlspecialchars($data['amount']); ?></td>
                <td><?php echo htmlspecialchars($data['user_id']); ?></td>
              </tr>
            <?php endforeach; ?>
                        
            <tr class="total-row">
                                          <td colspan="4"></td> 
                                          <td style="text-align:right;">Total:</td> 
                                          <td style="text-align:right;"><?php echo number_format($total_amount, 2); ?></td> 
                            <td></td>
            </tr>
          <?php else: ?>
            <tr>
                                          <td colspan="8">No daily process records found for this product.</td>
            </tr>
          <?php endif; ?>
        </tbody>
      </table>
    <?php else: ?>
      <h2>Product Not Found</h2>
      <p>The specified product code was not found. Please go back and select a valid product.</p>
    <?php endif; ?>
  </div>
</body>
</html>