<?php
// --- PHP Backend Logic ---
// This script retrieves, displays, and handles deletion of process data.

// Configuration variables for your database connection.
$servername = "localhost";
$username = "wintelsoft_vinod";
$password = "vinodbhaskar69*";
$dbname = "wintelsoft_svf";

$message = "";
$is_success = false;

// Check for a delete request.
if (isset($_GET['delete'])) {
    $process_code_to_delete = filter_input(INPUT_GET, 'delete', FILTER_SANITIZE_STRING);

    if ($process_code_to_delete) {
        $conn = new mysqli($servername, $username, $password, $dbname);
        if ($conn->connect_error) {
            die("Connection failed: " . $conn->connect_error);
        }

        // Use a prepared statement for the DELETE operation.
        $sql = "DELETE FROM processes WHERE process_code = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $process_code_to_delete);
        
        if ($stmt->execute()) {
            $message = "Record deleted successfully!";
            $is_success = true;
        } else {
            $message = "Error deleting record: " . $conn->error;
            $is_success = false;
        }
        
        $stmt->close();
        $conn->close();
    }
}

// Retrieve all data from the processes table.
$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$sql = "SELECT process_code, process_name, process_group, rate, unit_of_measurement FROM processes";
$result = $conn->query($sql);

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Processes</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap');
        
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f0f2f5;
            color: #333;
            line-height: 1.6;
            margin: 0;
            padding: 20px;
        }

        .container {
            max-width: 1000px;
            margin: 40px auto;
            background-color: #ffffff;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            width: 100%;
        }

        h2 {
            text-align: center;
            color: #ffffff;
            background-color: #3498db;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 30px;
            font-weight: 700;
            letter-spacing: 1px;
        }

        .alert-message {
            text-align: center;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 8px;
            font-weight: bold;
        }

        .alert-error {
            background-color: #e74c3c;
            color: white;
        }

        .alert-success {
            background-color: #2ecc71;
            color: white;
        }

        .process-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        .process-table th, .process-table td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }

        .process-table th {
            background-color: #f2f2f2;
            font-weight: bold;
            color: #555;
        }
        
        .action-links a {
            color: #3498db;
            text-decoration: none;
            font-weight: bold;
            margin-right: 15px;
        }

        .action-links a:hover {
            text-decoration: underline;
        }

        .delete-link {
            color: #e74c3c !important;
        }

        .add-link {
            display: inline-block;
            background-color: #2ecc71;
            color: white;
            padding: 10px 20px;
            border-radius: 8px;
            text-decoration: none;
            font-weight: bold;
            margin-bottom: 20px;
        }

        .add-link:hover {
            background-color: #27ae60;
        }

        /* Responsive design */
        @media (max-width: 600px) {
            .container {
                padding: 20px;
            }
            .process-table, .process-table thead, .process-table tbody, .process-table th, .process-table td, .process-table tr { 
                display: block; 
            }
            .process-table thead tr { 
                position: absolute;
                top: -9999px;
                left: -9999px;
            }
            .process-table tr { border: 1px solid #ccc; margin-bottom: 15px; }
            .process-table td { 
                border: none;
                border-bottom: 1px solid #eee; 
                position: relative;
                padding-left: 50%;
                text-align: right;
            }
            .process-table td:before { 
                position: absolute;
                top: 6px;
                left: 6px;
                width: 45%; 
                padding-right: 10px; 
                white-space: nowrap;
                text-align: left;
                font-weight: bold;
                color: #555;
            }
            .process-table td:nth-of-type(1):before { content: "Process Code"; }
            .process-table td:nth-of-type(2):before { content: "Process Name"; }
            .process-table td:nth-of-type(3):before { content: "Process Group"; }
            .process-table td:nth-of-type(4):before { content: "Rate"; }
            .process-table td:nth-of-type(5):before { content: "Unit"; }
            .process-table td:nth-of-type(6):before { content: "Actions"; }
        }
    </style>
    <script>
        function confirmDelete(processCode) {
            // Using a custom modal is better than `alert()` or `confirm()`
            // for a more controlled user experience in an immersive environment.
            // For this example, we'll use a simple alert as a placeholder.
            const message = "Are you sure you want to delete the process with code '" + processCode + "'?";
            if (window.confirm(message)) {
                window.location.href = "view_process.php?delete=" + processCode;
            }
        }
    </script>
</head>
<body>
    <div class="container">
        <h2>View Processes</h2>

        <?php if ($message): ?>
            <div class="alert-message <?php echo $is_success ? 'alert-success' : 'alert-error'; ?>">
                <p><?php echo htmlspecialchars($message); ?></p>
            </div>
        <?php endif; ?>

        <a href="add_process.php" class="add-link">Add New Process</a>

        <?php if ($result->num_rows > 0): ?>
            <table class="process-table">
                <thead>
                    <tr>
                        <th>Process Code</th>
                        <th>Process Name</th>
                        <th>Process Group</th>
                        <th>Rate</th>
                        <th>Unit of Measurement</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($row['process_code']); ?></td>
                        <td><?php echo htmlspecialchars($row['process_name']); ?></td>
                        <td><?php echo htmlspecialchars($row['process_group']); ?></td>
                        <td><?php echo htmlspecialchars($row['rate']); ?></td>
                        <td><?php echo htmlspecialchars($row['unit_of_measurement']); ?></td>
                        <td class="action-links">
                            <a href="edit_process.php?edit=<?php echo urlencode($row['process_code']); ?>">Edit</a>
                            <a href="#" class="delete-link" onclick="event.preventDefault(); confirmDelete('<?php echo htmlspecialchars($row['process_code']); ?>');">Delete</a>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="alert-message alert-error">
                <p>No processes found in the database.</p>
            </div>
        <?php endif; ?>

    </div>

<?php
$conn->close();
?>
</body>
</html>
