<?php
session_start();

// Database credentials
$servername = "localhost";
$username = "wintelsoft_vinod";
$password = "vinodbhaskar69*";
$dbname = "wintelsoft_svf";

// 1. Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Establish connection
$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// 2. Fetch all distinct salesman names (from the 'salesman' column in 'products') for the dropdown
$salesman_names = [];
// MODIFIED SQL: Selecting DISTINCT 'salesman' column from the 'products' table.
// We are now only querying the 'products' table.
$sql_salesmen = "
    SELECT DISTINCT salesman 
    FROM products 
    ORDER BY salesman ASC
";
$result_salesmen = $conn->query($sql_salesmen);

if ($result_salesmen && $result_salesmen->num_rows > 0) {
    while($row = $result_salesmen->fetch_assoc()) {
        // Store the salesman name directly
        if (!empty($row['salesman'])) {
             $salesman_names[] = htmlspecialchars($row['salesman']);
        }
    }
}
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Product View Selection</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap');
        
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f0f2f5;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
            padding: 20px;
        }

        .container {
            background-color: #ffffff;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 500px;
        }

        h2 {
            text-align: center;
            color: #ffffff;
            background-color: #3498db;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 30px;
            font-weight: 700;
        }

        .form-group {
            margin-bottom: 20px;
            text-align: left;
        }

        label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: bold;
        }

        select, input[type="date"] {
            width: 100%;
            padding: 12px;
            border: 1px solid #ccc;
            border-radius: 8px;
            box-sizing: border-box;
            font-size: 16px;
        }

        button {
            width: 100%;
            padding: 15px;
            background-color: #2ecc71;
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 18px;
            font-weight: bold;
            cursor: pointer;
            transition: background-color 0.3s, transform 0.2s;
        }

        button:hover {
            background-color: #27ae60;
            transform: translateY(-2px);
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Select Viewing Criteria</h2>
        
        <!-- Form submits to view_products_selected.php using GET and opens in a new tab -->
        <form action="view_products_selected.php" method="get" target="_blank">
            
            <div class="form-group">
                <!-- MODIFIED: Label remains Salesman -->
                <label for="user_filter">Filter by Salesman:</label>
                <select name="user_filter" id="user_filter" required>
                    <!-- MODIFIED: Option text remains All Salesmen -->
                    <option value="all">All Salesmen</option>
                    <?php 
                    // Loop through the $salesman_names array
                    foreach ($salesman_names as $name) {
                        // The value and the displayed text are both the salesman's name
                        echo "<option value=\"{$name}\">{$name}</option>";
                    }
                    ?>
                </select>
            </div>
            
            <div class="form-group">
                <label for="start_date">Start Delivery Date:</label>
                <!-- Sets default to today's date minus 30 days -->
                <input type="date" id="start_date" name="start_date" value="<?php echo date('Y-m-d', strtotime('-30 days')); ?>" required>
            </div>
            
            <div class="form-group">
                <label for="end_date">End Delivery Date:</label>
                <!-- Sets default to today's date -->
                <input type="date" id="end_date" name="end_date" value="<?php echo date('Y-m-d'); ?>" required>
            </div>
            
            <button type="submit">View Products</button>
        </form>
    </div>
</body>
</html>
